/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.SymbolInsertable;
import net.replaceitem.symbolchat.gui.container.ContainerWidgetImpl;
import net.replaceitem.symbolchat.gui.widget.SymbolTabWidget;
import net.replaceitem.symbolchat.gui.widget.TabSelectionWidget;
import net.replaceitem.symbolchat.resource.SymbolTab;

public class SymbolSelectionPanel
extends ContainerWidgetImpl {
    private final TabSelectionWidget tabSelectionWidget;
    private final List<SymbolTabWidget> tabs = new ArrayList<SymbolTabWidget>();
    private static final int MIN_COLUMNS = 8;
    protected final SymbolInsertable symbolInsertable;

    public static int getWidthForTabs(int tabCount) {
        int columns = Math.max(tabCount, 8);
        return columns * 13 + 1 + 2;
    }

    public SymbolSelectionPanel(int x, int y, int height, SymbolInsertable symbolInsertable) {
        super(x, y, 0, height);
        int columns = Math.max(SymbolChat.symbolManager.getTabs().size(), 8);
        this.field_22758 = SymbolSelectionPanel.getWidthForTabs(SymbolChat.symbolManager.getTabs().size());
        this.field_22764 = SymbolChat.config.getKeepPanelOpen() && SymbolChat.isPanelOpen;
        this.symbolInsertable = symbolInsertable;
        this.tabSelectionWidget = new TabSelectionWidget(this.method_46426(), this.method_46427() + 1, this.field_22758){

            @Override
            protected void onTabSwitched(int previousIndex, int newIndex) {
                SymbolSelectionPanel.this.getSymbolTab(newIndex).ifPresent(SymbolSelectionPanel.this::setVisibleTab);
                SymbolSelectionPanel.this.getCurrentTab().ifPresent(SymbolTabWidget::refresh);
            }
        };
        this.addChildren(this.tabSelectionWidget);
        for (SymbolTab tab : SymbolChat.symbolManager.getTabs()) {
            this.addTab(tab, columns);
        }
        this.getCurrentTab().ifPresent(this::setVisibleTab);
        this.tabSelectionWidget.refreshPositions();
    }

    private void setVisibleTab(SymbolTabWidget tab) {
        this.tabs.forEach(symbolTabWidget -> {
            symbolTabWidget.field_22764 = false;
        });
        tab.field_22764 = true;
    }

    private void addTab(SymbolTab tab, int columns) {
        int tabY = this.method_46427() + this.tabSelectionWidget.method_25364() + 2;
        int tabHeight = this.field_22759 - (this.tabSelectionWidget.method_25364() + 2) - 1;
        SymbolTabWidget tabWidget = new SymbolTabWidget(this.method_46426(), tabY, this.field_22758, tabHeight, tab, this, columns);
        this.tabs.add(tabWidget);
        this.tabSelectionWidget.addTab(tab);
        this.addChildren((class_364)tabWidget);
    }

    public Optional<SymbolTabWidget> getSymbolTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            return Optional.empty();
        }
        return Optional.of(this.tabs.get(index));
    }

    public Optional<SymbolTabWidget> getCurrentTab() {
        return this.getSymbolTab(this.tabSelectionWidget.getSelectedTab());
    }

    public SymbolInsertable getSymbolInsertable() {
        return this.symbolInsertable;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void toggleVisible() {
        boolean bl = this.field_22764 = !this.field_22764;
        if (SymbolChat.config.getKeepPanelOpen()) {
            SymbolChat.isPanelOpen = this.field_22764;
        }
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22904(0.0, 0.0, 350.0);
        RenderSystem.disableDepthTest();
        drawContext.method_25294(this.method_46426(), this.method_46427() + 13 + 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, SymbolChat.config.getHudColor());
        super.method_48579(drawContext, mouseX, mouseY, delta);
        drawContext.method_51448().method_22909();
    }
}

